/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.resource;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.toma.gunsrpg.util.helper.JsonHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraftforge.items.IItemHandler;

public class MultiIngredient {
    private final Ingredient ingredient;
    private final int count;

    public MultiIngredient(Ingredient ingredient, int count) {
        this.ingredient = ingredient;
        this.count = count;
    }

    public static boolean test(IInventory inventory, int[] slots, List<MultiIngredient> ingredients) {
        for (int slot : slots) {
            ItemStack stack = inventory.func_70301_a(slot);
            if (stack.func_190926_b()) continue;
            boolean validItemStack = false;
            for (MultiIngredient ingredient : ingredients) {
                if (!ingredient.ingredient.test(stack)) continue;
                validItemStack = true;
            }
            if (validItemStack) continue;
            return false;
        }
        Object object = ingredients.iterator();
        while (object.hasNext()) {
            MultiIngredient ingredient = (MultiIngredient)object.next();
            if (ingredient.test(inventory, slots)) continue;
            return false;
        }
        return true;
    }

    public static MultiIngredient parseJson(JsonElement element) throws JsonParseException {
        JsonObject object = JsonHelper.asJsonObject(element);
        JsonObject ingredientJson = JSONUtils.func_152754_s((JsonObject)object, (String)"ingredient");
        Ingredient ingredient = Ingredient.func_199802_a((JsonElement)ingredientJson);
        int count = JSONUtils.func_151208_a((JsonObject)object, (String)"count", (int)1);
        return new MultiIngredient(ingredient, count);
    }

    public void encode(PacketBuffer buffer) {
        this.ingredient.func_199564_a(buffer);
        buffer.writeInt(this.count);
    }

    public static MultiIngredient decode(PacketBuffer buffer) {
        Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
        int count = buffer.readInt();
        return new MultiIngredient(ingredient, count);
    }

    public boolean test(IInventory container, int[] slots) {
        return this.test(container, slots, false, IInventory::func_70301_a);
    }

    public boolean test(IItemHandler itemHandler, int[] slots) {
        return this.test(itemHandler, slots, false, IItemHandler::getStackInSlot);
    }

    private <C> boolean test(C container, int[] slots, boolean ignoreCount, BiFunction<C, Integer, ItemStack> itemProvider) {
        int remaining = this.count;
        for (int slot : slots) {
            ItemStack stack = itemProvider.apply(container, slot);
            if (!this.ingredient.test(stack)) continue;
            if (ignoreCount) {
                return true;
            }
            if ((remaining -= stack.func_190916_E()) <= 0) break;
        }
        return remaining <= 0;
    }

    public void consume(IInventory inventory, int[] slots) {
        this.consume(inventory, slots, IInventory::func_70301_a);
    }

    public void consume(IItemHandler itemHandler, int[] slots) {
        this.consume(itemHandler, slots, IItemHandler::getStackInSlot);
    }

    private <C> void consume(C container, int[] slots, BiFunction<C, Integer, ItemStack> itemProvider) {
        int remaining = this.count;
        for (int slot : slots) {
            ItemStack stack = itemProvider.apply(container, slot);
            if (!this.ingredient.test(stack)) continue;
            int toConsume = Math.min(remaining, stack.func_190916_E());
            stack.func_190918_g(toConsume);
            if ((remaining -= toConsume) <= 0) break;
        }
    }

    public void consume(List<ItemStack> list) {
        int remaining = this.count;
        for (ItemStack stack : list) {
            if (!this.ingredient.test(stack)) continue;
            int toConsume = Math.min(remaining, stack.func_190916_E());
            stack.func_190918_g(toConsume);
            if ((remaining -= toConsume) > 0) continue;
            break;
        }
    }

    public List<ItemStack> getItemStackList() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (ItemStack stack : this.ingredient.func_193365_a()) {
            ItemStack itemStack = stack.func_77946_l();
            itemStack.func_190920_e(this.count);
            list.add(itemStack);
        }
        return list;
    }
}

